# 🔍 Fingerprint Collector

Rakip botun ayarlarını öğrenmek için websitene gelen tüm istekleri yakalar ve analiz eder.

## 📁 Dosyalar

| Dosya | Açıklama |
|-------|----------|
| `_collector.php` | Ana collector - her isteği yakalar |
| `_viewer.php` | Dashboard - verileri görüntüle |
| `.htaccess.example` | Örnek .htaccess yapılandırması |

## 🚀 Kurulum

### 1. Dosyaları Yükle
Tüm dosyaları web sitenin **root dizinine** yükle:
```
public_html/
├── _collector.php
├── _viewer.php
├── .htaccess         ← .htaccess.example'ı kopyala
└── data/             ← Otomatik oluşur
    └── fingerprints.db
```

### 2. Secret Key'i Değiştir
Her iki PHP dosyasında da `SECRET_KEY` değerini değiştir:
```php
define('COLLECTOR_SECRET_KEY', 'senin_gizli_anahtarin_123');
```

### 3. .htaccess Ayarla
`.htaccess.example` dosyasını `.htaccess` olarak kopyala ve yolu düzenle:
```apache
php_value auto_prepend_file "/home/KULLANICI_ADIN/public_html/_collector.php"
```

### 4. Verileri Görüntüle
```
https://senin-siten.com/_viewer.php?key=senin_gizli_anahtarin_123
```

## 📊 Toplanan Veriler

| Veri | Açıklama | Neden Önemli |
|------|----------|--------------|
| **User-Agent** | Tarayıcı/OS bilgisi | Rakibin UA havuzunu öğren |
| **Header Sıralaması** | Header'ların gönderilme sırası | Gerçek tarayıcı mı bot mu anla |
| **Accept-Language** | Dil tercihleri | Hangi dili hedefliyor |
| **Accept-Encoding** | Sıkıştırma desteği | Brotli kullanıyor mu |
| **Sec-Fetch-*** | Modern tarayıcı güvenlik header'ları | TLS/browser profile |
| **Referer** | Nereden geldiği | SERP'ten mi, direkt mi |
| **Full URL** | Query string dahil tam URL | URL pattern analizi |
| **Request Timing** | İstek zamanlaması | Burst pattern, rate |

## 🔄 JSON Export

Verileri programatik olarak çekmek için:
```
?key=SECRET&export=all         → Tüm veriler
?key=SECRET&export=user_agents → Sadece User-Agent'lar
?key=SECRET&export=headers     → Tüm header istatistikleri
?key=SECRET&export=patterns    → Header sıralama pattern'leri
?key=SECRET&export=raw         → Son 100 raw request
```

## 💾 Veri Yönetimi

- **Raw Request Samples**: Son 500 istek saklanır (ayarlanabilir)
- **Timing Data**: 1 saatten eski veriler otomatik silinir
- **Aggregation**: Aynı değerler count ile gruplandığı için 30K istek = ~100-500 satır

## 🛡️ Güvenlik

- `/data/` klasörü `.htaccess` ile korunur
- Viewer sadece secret key ile erişilebilir
- IP'ler hash'lenerek saklanır (privacy)

## ⚠️ Notlar

1. **SQLite Extension**: Hostingte SQLite desteği olmalı (çoğunda var)
2. **Yazma İzni**: `data/` klasörüne yazma izni gerekli
3. **TLS Fingerprint**: Sunucu tarafında JA3 alamazsın, bunun için Cloudflare veya özel proxy gerekir

## 🎯 Kullanım Senaryosu

1. Rakip botun sana 30K hit attığını gör
2. Viewer'dan User-Agent listesini kontrol et
3. Rakibin hangi UA havuzu kullandığını öğren
4. Header pattern'ini analiz et - hangi TLS library kullanıyor?
5. Kendi botunu optimize et!
